/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************

   Filename:
    $Id: PNM_PNIOAPCTL_Public.h 13657 2011-01-18 07:17:11Z Benjamin $
   Last Modification:
    $LastChangedBy: Benjamin $
    $LastChangedDate: 2011-01-18 08:17:11 +0100 (Di, 18 Jan 2011) $
    $LastChangedRevision: 13657 $

   Targets:
    Win32/ANSI   : no
    Win32/Unicode: no (define _UNICODE)
    WinCE        : yes
    rcX          : yes

   Description:

    PNIO APCTL
    public

   Changes:

    Date        Author   Description
    ----------- -------- ---------------------------------------------------------
    2011-01-18  bm       fixed wrong comment in description of parameter ulTimeout
                            in packet APIOC_DCP_IDENT_ALL_REQ_T (from ms to s)

    2010-10-18  bm       added definition of flag PNIO_APCTL_DCP_SET_IP_PERMANENT

    2010-10-13  bm       added definition of flag PNIO_IOD_DIAG_CONNECT_HELLO_TRIGGERED

    2009-10-05  bm       added packet definition and command for GetCmctlConnectResults

    2009-10-01  bm       added packet definition and command for DCP ResetFactorySettings

    2009-07-23  bm       complete reorganization of the file
                            all definitions belonging to a special service now
                               reside close to each other
                            moved all internal definitions to different files

    2009-07-06  bm       extended definition of APIOC_DIAG_DATA_IND_T


     Version    Date        Author   Description
     ---------------------------------------------------------------------------
     37          2009-05-12  bm       added definition of GET_STACK_DIAGNOSIS

     36          2008-09-06  bm       PNIO_APCTL_DIAG_BUFF_SIZE is now 204
                                         this is necessary because DiagAlarm may consist of 200 byte
                                         plus additional 2 byte UserStructIdentifier (using 204 for alignment)

     35          2008-09-06  bm       PNIO_APCTL_DIAG_BUFF_SIZE is now 200

     34          2008-04-09  bm       moved some private defines to PNIOAPCTL_Private.h
                                      moved some private commands to PNIOAPCTL_Commands.h
                                      cleanup include-files

     33          ---         bm       initial version

**************************************************************************************/
/**
 * @file PNIOAPCTL_Public.h
 *  PNIO APCTL - public definition of task
 *
 * The header contains the public definition of task.
 * It has to be included by another task to get access of task specific definition.
 *
 */
#ifndef __PNIO_APCTL_PUBLIC_H
#define __PNIO_APCTL_PUBLIC_H

#include "PNIO_spec.h"                  /* some PROFINET global definitions */

/*************************************************************************************/
/** @name Queue Name
 *
 * Use the queue name to identify the process queue of task 'PNIO APCTL'.
 */
#define PNIO_APCTL_QUEUE_NAME        "QUE_PNIO_APCTL"

/** @} */


/*************************************************************************************/
/* packet commands */

#define  PNIO_APCTL_CMD_DCP_SET_NAME_REQ            0x00000C0A
#define  PNIO_APCTL_CMD_DCP_SET_NAME_CNF            0x00000C0B
#define  PNIO_APCTL_CMD_DCP_SET_IP_REQ              0x00000C0C
#define  PNIO_APCTL_CMD_DCP_SET_IP_CNF              0x00000C0D
#define  PNIO_APCTL_CMD_DCP_SET_SIGNAL_REQ          0x00000C0E
#define  PNIO_APCTL_CMD_DCP_SET_SIGNAL_CNF          0x00000C0F
#define  PNIO_APCTL_CMD_DCP_IDENT_ALL_REQ           0x00000C10
#define  PNIO_APCTL_CMD_DCP_IDENT_ALL_CNF           0x00000C11

#define  PNIO_APCTL_CMD_READ_REQ                    0x00000C1A
#define  PNIO_APCTL_CMD_READ_CNF                    0x00000C1B
#define  PNIO_APCTL_CMD_WRITE_REQ                   0x00000C1C
#define  PNIO_APCTL_CMD_WRITE_CNF                   0x00000C1D
#define  PNIO_APCTL_CMD_READ_IMPL_REQ               0x00000C1E
#define  PNIO_APCTL_CMD_READ_IMPL_CNF               0x00000C1F

#define  PNIO_APCTL_CMD_GET_DEVICE_DIAGNOSIS_REQ    0x00000C22
#define  PNIO_APCTL_CMD_GET_DEVICE_DIAGNOSIS_CNF    0x00000C23

#define  PNIO_APCTL_CMD_DCP_IDENT_IND               0x00000C24
#define  PNIO_APCTL_CMD_DCP_IDENT_RSP               0x00000C25
#define  PNIO_APCTL_CMD_DCP_IDENT_FINISHED_IND      0x00000C2C
#define  PNIO_APCTL_CMD_DCP_IDENT_FINISHED_RSP      0x00000C2D

#define  PNIO_APCTL_CMD_APPL_ALARM_ACK_REQ          0x00000C26
#define  PNIO_APCTL_CMD_APPL_ALARM_ACK_CNF          0x00000C27

#define  PNIO_APCTL_CMD_RELEASE_REQ                 0x00000C2E
#define  PNIO_APCTL_CMD_RELEASE_CNF                 0x00000C2F

#define  PNIO_APCTL_CMD_GET_MOD_DIFF_BLOCK_REQ      0x00000C60
#define  PNIO_APCTL_CMD_GET_MOD_DIFF_BLOCK_CNF      0x00000C61

/* commands for packet-configuration via DPM */
#define  PNM_APCTL_CMD_SET_CONFIG_PNM_REQ           0x00000C30
#define  PNM_APCTL_CMD_SET_CONFIG_PNM_CNF           0x00000C31
#define  PNM_APCTL_CMD_SET_CONFIG_IOD_REQ           0x00000C32
#define  PNM_APCTL_CMD_SET_CONFIG_IOD_CNF           0x00000C33
#define  PNM_APCTL_CMD_SET_CONFIG_IOD_IOCR_REQ      0x00000C34
#define  PNM_APCTL_CMD_SET_CONFIG_IOD_IOCR_CNF      0x00000C35
#define  PNM_APCTL_CMD_SET_CONFIG_IOD_AP_REQ        0x00000C36
#define  PNM_APCTL_CMD_SET_CONFIG_IOD_AP_CNF        0x00000C37
#define  PNM_APCTL_CMD_SET_CONFIG_IOD_MODULE_REQ    0x00000C38
#define  PNM_APCTL_CMD_SET_CONFIG_IOD_MODULE_CNF    0x00000C39
#define  PNM_APCTL_CMD_SET_CONFIG_IOD_SUBMODULE_REQ 0x00000C3A
#define  PNM_APCTL_CMD_SET_CONFIG_IOD_SUBMODULE_CNF 0x00000C3B
#define  PNM_APCTL_CMD_SET_CONFIG_IOD_SUBMDESCR_REQ 0x00000C3C
#define  PNM_APCTL_CMD_SET_CONFIG_IOD_SUBMDESCR_CNF 0x00000C3D
#define  PNM_APCTL_CMD_SET_CONFIG_IOD_RECDATA_REQ  	0x00000C3E
#define  PNM_APCTL_CMD_SET_CONFIG_IOD_RECDATA_CNF   0x00000C3F
#define  PNM_APCTL_CMD_SET_CONFIG_DWNL_FIN_REQ      0x00000C40
#define  PNM_APCTL_CMD_SET_CONFIG_DWNL_FIN_CNF      0x00000C41
#define  PNM_APCTL_CMD_SET_CONFIG_PNM_EXT_REQ       0x00000C42
#define  PNM_APCTL_CMD_SET_CONFIG_PNM_EXT_CNF       0x00000C43
#define  PNM_APCTL_CMD_SET_CONFIG_IOD_EXT_REQ       0x00000C44
#define  PNM_APCTL_CMD_SET_CONFIG_IOD_EXT_CNF       0x00000C45
#define  PNM_APCTL_CMD_SET_CONFIG_IOD_INTF_SUBM_REQ 0x00000C46
#define  PNM_APCTL_CMD_SET_CONFIG_IOD_INTF_SUBM_CNF 0x00000C47
#define  PNM_APCTL_CMD_SET_CONFIG_IOD_PORT_SUBM_REQ 0x00000C48
#define  PNM_APCTL_CMD_SET_CONFIG_IOD_PORT_SUBM_CNF 0x00000C49


#define  PNIO_APCTL_CMD_APPL_ALARM_IND              0x00000C80
#define  PNIO_APCTL_CMD_APPL_ALARM_RSP              0x00000C81
#define  PNIO_APCTL_CMD_APPL_DIAG_DATA_IND          0x00000C82
#define  PNIO_APCTL_CMD_APPL_DIAG_DATA_RSP          0x00000C83

#define  PNIO_APCTL_CMD_GET_STACK_DIAG_REQ          0x00000C84
#define  PNIO_APCTL_CMD_GET_STACK_DIAG_CNF          0x00000C85

#define  PNIO_APCTL_CMD_DCP_RESET_FACTORY_REQ       0x00000C86
#define  PNIO_APCTL_CMD_DCP_RESET_FACTORY_CNF       0x00000C87

#define  PNIO_APCTL_CMD_GET_CMCTL_CONNECT_RES_REQ   0x00000C88
#define  PNIO_APCTL_CMD_GET_CMCTL_CONNECT_RES_CNF   0x00000C89


/*************************************************************************************/
/* packets */

/* pragma pack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_PACK_1(__PNIO_APCTL_PACKET)
#endif


/*************************************************************************************/
/*                        A C Y C L I C     S E R V I C E S                          */
/*************************************************************************************/

/*
 * READ RECORD SERVICE
 */

/** read request */
typedef __PACKED_PRE struct
{
  /** handle to IO-Device to read from */
  TLR_UINT32      ulHandle;
  /** API to read from */
  TLR_UINT32      ulApi;
  /** maximum supported length of read response data */
  TLR_UINT32      ulDataLength;
  /** slot to read from*/
  TLR_UINT16      usSlot;
  /** subslot to read from */
  TLR_UINT16      usSubSlot;
  /** index to read from */
  TLR_UINT16      usIndex;
} __PACKED_POST APIOC_READ_REQ_DATA_T;

typedef struct
{
  /** packet header */
  TLR_PACKET_HEADER_T                    tHead;
  /** packet data */
  APIOC_READ_REQ_DATA_T                  tData;
} APIOC_READ_REQ_T;

/** read confirmation */
typedef __PACKED_PRE struct
{
  /** handle to IO-Device to read from */
  TLR_UINT32      ulHandle;
  /** PNIO status */
  TLR_UINT32      ulPnio;
  /** API read from */
  TLR_UINT32      ulApi;
  /** total length of read response data */
  TLR_UINT32      ulDataLength;
  /** slot read from*/
  TLR_UINT16      usSlot;
  /** subslot read from */
  TLR_UINT16      usSubSlot;
  /** index read from */
  TLR_UINT16      usIndex;
  /** Additional Value 1 */
  TLR_UINT16      usAddVal1;
  /** Additional Value 2 */
  TLR_UINT16      usAddVal2;
  /** alignment - value does not matter */
  TLR_UINT16      usAlign;
  /** first byte of data read from IO-Device  -  other data lies directly behind it */
  TLR_UINT8      abReadData[1];
} __PACKED_POST APIOC_READ_CNF_DATA_T;

typedef struct
{
  /** packet header */
  TLR_PACKET_HEADER_T                    tHead;
  /** packet data */
  APIOC_READ_CNF_DATA_T                  tData;
} __PACKED_POST APIOC_READ_CNF_T;

/** packet union */
typedef union
{
  /** request packet */
  APIOC_READ_REQ_T                       tReq;
  /* confirmation packet */
  APIOC_READ_CNF_T                       tCnf;
} APIOC_READ_PCK_T;


/*
 * WRITE RECORD SERVICE
 */

/** write request */
typedef __PACKED_PRE struct
{
  /** handle to IO-Device to write to */
  TLR_UINT32      ulHandle;
  /** API to write to */
  TLR_UINT32      ulApi;
  /** total length of data to write */
  TLR_UINT32      ulDataLength;
  /** slot to write to */
  TLR_UINT16      usSlot;
  /** subslot to write to */
  TLR_UINT16      usSubSlot;
  /** index to write to */
  TLR_UINT16      usIndex;
  /** alignment - value does not matter */
  TLR_UINT16      usAlign;
  /** first byte of data to write to IO-Device  -  other data lies directly behind it */
  TLR_UINT8      abWriteData[1];
} __PACKED_POST APIOC_WRITE_REQ_DATA_T;

typedef struct
{
  /** packet header */
  TLR_PACKET_HEADER_T                    tHead;
  /** packet data */
  APIOC_WRITE_REQ_DATA_T                 tData;
} APIOC_WRITE_REQ_T;

/** write confirmation */
typedef __PACKED_PRE struct
{
  /** handle to IO-Device written to */
  TLR_UINT32      ulHandle;
  /** PNIO status */
  TLR_UINT32      ulPnio;
  /** API written to */
  TLR_UINT32      ulApi;
  /** slot written to */
  TLR_UINT16      usSlot;
  /** subslot written to */
  TLR_UINT16      usSubSlot;
  /** index written to */
  TLR_UINT16      usIndex;
  /** Additional Value 1 */
  TLR_UINT16      usAddVal1;
  /** Additional Value 2 */
  TLR_UINT16      usAddVal2;
} __PACKED_POST APIOC_WRITE_CNF_DATA_T;

typedef struct
{
  /** packet header */
  TLR_PACKET_HEADER_T                    tHead;
  /** packet data */
  APIOC_WRITE_CNF_DATA_T                 tData;
} APIOC_WRITE_CNF_T;

/** packet union */
typedef union
{
  /** request packet */
  APIOC_WRITE_REQ_T                      tReq;
  /* confirmation packet */
  APIOC_WRITE_CNF_T                      tCnf;
} APIOC_WRITE_PCK_T;


/*
 * RELEASE IO-DEVICE SERVICE
 */

/** Release Request */
typedef __PACKED_PRE struct
{
  /** device handle */
  TLR_UINT32    ulHandle;
} __PACKED_POST APIOC_RELEASE_REQ_DATA_T;

typedef struct
{
  /** packet header */
  TLR_PACKET_HEADER_T                    tHead;
  /** packet data */
  APIOC_RELEASE_REQ_DATA_T               tData;
} APIOC_RELEASE_REQ_T;

/** Release Confirmation */
typedef APIOC_RELEASE_REQ_T APIOC_RELEASE_CNF_T;

/** packet union */
typedef union
{
  /** request packet */
  APIOC_RELEASE_REQ_T                    tReq;
  /* confirmation packet */
  APIOC_RELEASE_CNF_T                    tCnf;
} APIOC_RELEASE_PCK_T;


/*
 * READ IMPLICIT RECORD SERVICE
 */

/** read implicit request */
typedef __PACKED_PRE struct
{
  /** IP-address of the IO-Device to read from */
  TLR_UINT32      ulIPAddress;
  /** DeviceID */
  TLR_UINT16      usDeviceId;
  /** VendorID */
  TLR_UINT16      usVendorId;
  /** ObjectUUID InstanceID */
  TLR_UINT16      usInstanceId;
  /** reserved */
  TLR_UINT16      usReserved;
  /** API to read from */
  TLR_UINT32      ulApi;
  /** maximum supported length of read response data */
  TLR_UINT32      ulDataLength;
  /** slot to read from*/
  TLR_UINT16      usSlot;
  /** subslot to read from */
  TLR_UINT16      usSubSlot;
  /** index to read from */
  TLR_UINT16      usIndex;
} __PACKED_POST APIOC_READ_IMPL_REQ_DATA_T;

typedef struct
{
  /** packet header */
  TLR_PACKET_HEADER_T                    tHead;
  /** packet data */
  APIOC_READ_IMPL_REQ_DATA_T             tData;
} APIOC_READ_IMPL_REQ_T;

/** read implicit confirmation */
typedef __PACKED_PRE struct
{
  /** PNIO status */
  TLR_UINT32      ulPnio;
  /** API read from */
  TLR_UINT32      ulApi;
  /** total length of read response data */
  TLR_UINT32      ulDataLength;
  /** slot read from*/
  TLR_UINT16      usSlot;
  /** subslot read from */
  TLR_UINT16      usSubSlot;
  /** index read from */
  TLR_UINT16      usIndex;
  /** Additional Value 1 */
  TLR_UINT16      usAddVal1;
  /** Additional Value 2 */
  TLR_UINT16      usAddVal2;
  /** alignment - value does not matter */
  TLR_UINT16      usAlign;
  /** first byte of data read from IO-Device  -  other data lies directly behind it */
  TLR_UINT8      abReadData[1];
} __PACKED_POST APIOC_READ_IMPL_CNF_DATA_T;

typedef struct
{
  /** packet header */
  TLR_PACKET_HEADER_T                    tHead;
  /** packet data */
  APIOC_READ_IMPL_CNF_DATA_T             tData;
} __PACKED_POST APIOC_READ_IMPL_CNF_T;

/** packet union */
typedef union
{
  /** request packet */
  APIOC_READ_IMPL_REQ_T                  tReq;
  /* confirmation packet */
  APIOC_READ_IMPL_CNF_T                  tCnf;
} APIOC_READ_IMPL_PCK_T;



/*************************************************************************************/
/*                           D C P     S E R V I C E S                               */
/*************************************************************************************/

/*
 * DCP SET NAMEOFSTATION SERVICE
 */

/** DCP set name request */
typedef __PACKED_PRE struct
{
  /** length of NEW NameOfStation */
  TLR_UINT32       ulLenName;
  /** Flags */
  TLR_UINT32        ulFlags;
  /** MAC address of IO-device */
  TLR_UINT8        tMac[PNIO_LEN_MAC_ADDR];
  /** NEW NameOfStation for IO-device */
  TLR_UINT8        tName[PNIO_MAX_NAME_OF_STATION];
} __PACKED_POST APIOC_DCP_SET_NAME_REQ_DATA_T;

typedef struct
{
  /** packet header */
  TLR_PACKET_HEADER_T                    tHead;
  /** packet data */
  APIOC_DCP_SET_NAME_REQ_DATA_T          tData;
} APIOC_DCP_SET_NAME_REQ_T;

/** DCP set name confirmation */
typedef __PACKED_PRE struct
{
  /** DCP status */
  TLR_UINT32       ulDcpStatus;
} __PACKED_POST APIOC_DCP_SET_CNF_DATA_T;

typedef struct
{
  /** packet header */
  TLR_PACKET_HEADER_T                    tHead;
  /** packet data */
  APIOC_DCP_SET_CNF_DATA_T               tData;
} APIOC_DCP_SET_NAME_CNF_T;

/** packet union */
typedef union
{
  /** request packet */
  APIOC_DCP_SET_NAME_REQ_T               tReq;
  /** confirmation packet */
  APIOC_DCP_SET_NAME_CNF_T               tCnf;
} APIOC_DCP_SET_NAME_PCK_T;


/*
 * DCP SET IP-ADDRESS SERVICE
 */

#define PNIO_APCTL_DCP_SET_IP_PERMANENT      0x20

/** DCP set IP request */
typedef __PACKED_PRE struct
{
  /** NEW IP for IO-device */
  TLR_UINT32        ulAddr;
  /** NEW subnet mask */
  TLR_UINT32        ulMask;
  /** NEW router, gateway */
  TLR_UINT32        ulGate;
  /** Flags */
  TLR_UINT32        ulFlags;
  /** MAC address of IO-device */
  TLR_UINT8         tMac[PNIO_LEN_MAC_ADDR];
} __PACKED_POST APIOC_DCP_SET_IP_REQ_DATA_T;

typedef struct
{
  /** packet header */
  TLR_PACKET_HEADER_T                    tHead;
  /** packet data */
  APIOC_DCP_SET_IP_REQ_DATA_T            tData;
} APIOC_DCP_SET_IP_REQ_T;

/** DCP set IP confirmation */
typedef struct
{
  /** packet header */
  TLR_PACKET_HEADER_T                    tHead;
  /** packet data */
  APIOC_DCP_SET_CNF_DATA_T               tData;
} APIOC_DCP_SET_IP_CNF_T;

/** packet union */
typedef union
{
  /** request packet */
  APIOC_DCP_SET_IP_REQ_T                 tReq;
  /** confirmation packet */
  APIOC_DCP_SET_IP_CNF_T                 tCnf;
} APIOC_DCP_SET_IP_PCK_T;


/*
 * DCP SIGNAL SERVICE
 */

#define PNIO_APCTL_DCP_STOP_SIGNAL      0x1
#define PNIO_APCTL_DCP_START_SIGNAL     0x2

/** DCP set SIGNAL request */
typedef __PACKED_PRE struct
{
  /** flags */
  TLR_UINT32       ulFlags;
  /** MAC address of IO-device */
  TLR_UINT8        tMac[PNIO_LEN_MAC_ADDR];
} __PACKED_POST APIOC_DCP_SET_SIGNAL_REQ_DATA_T;

typedef struct
{
  /** packet header */
  TLR_PACKET_HEADER_T                    tHead;
  /** packet data */
  APIOC_DCP_SET_SIGNAL_REQ_DATA_T        tData;
} APIOC_DCP_SET_SIGNAL_REQ_T;

/** DCP set SIGNAL confirmation */
typedef struct
{
  /** packet header */
  TLR_PACKET_HEADER_T                    tHead;
  /** packet data */
  APIOC_DCP_SET_CNF_DATA_T               tData;
} APIOC_DCP_SET_SIGNAL_CNF_T;

/** packet union */
typedef union
{
  /** request packet */
  APIOC_DCP_SET_SIGNAL_REQ_T             tReq;
  /** confirmation packet */
  APIOC_DCP_SET_SIGNAL_CNF_T             tCnf;
} APIOC_DCP_SET_SIGNAL_PCK_T;


/*
 * DCP IDENTIFY ALL SERVICE
 */

/** DCP IDENT ALL request */
typedef __PACKED_PRE struct
{
  /** timeout in seconds to wait for responses */
  TLR_UINT32    ulTimeout;
} __PACKED_POST APIOC_DCP_IDENT_ALL_REQ_DATA_T;

typedef struct
{
  /** packet header */
  TLR_PACKET_HEADER_T                    tHead;
  /** packet data */
  APIOC_DCP_IDENT_ALL_REQ_DATA_T         tData;
} APIOC_DCP_IDENT_ALL_REQ_T;

/** DCP IDENT ALL confirmation */
typedef __PACKED_PRE struct
{
  /** reserved */
  TLR_UINT32    ulReserved;
} __PACKED_POST APIOC_DCP_IDENT_ALL_CNF_DATA_T;

typedef struct
{
  /** packet header */
  TLR_PACKET_HEADER_T                    tHead;
  /** packet data */
  APIOC_DCP_IDENT_ALL_CNF_DATA_T         tData;
} APIOC_DCP_IDENT_ALL_CNF_T;

/** packet union */
typedef union
{
  /** request packet */
  APIOC_DCP_IDENT_ALL_REQ_T              tReq;
  /** confirmation packet */
  APIOC_DCP_IDENT_ALL_CNF_T              tCnf;
} APIOC_DCP_IDENT_ALL_PCK_T;


/*
 * DCP IDENTIFY ENTRY SERVICE
 */

/** DCP IDENT Entry indication */
typedef __PACKED_PRE struct
{
    /** IP used by device */
    TLR_UINT32  ulIp;
    /** Subnet Mask used by device */
    TLR_UINT32  ulNetMask;
    /** Gateway used by device */
    TLR_UINT32  ulGateway;
    /** length of NameOfStation */
    TLR_UINT16  usLenName;
    /** length of TypeOfStation */
    TLR_UINT16  usLenType;
    /** vendor ID of device */
    TLR_UINT16  usVendorId;
    /** device ID of device */
    TLR_UINT16  usDeviceId;
    /** role of device */
    TLR_UINT16  usDeviceRole;
    /** MAC address of device */
    TLR_UINT8   abMac[6];
    /** first byte of NameOfStation, remaining byte follow directly behind */
    TLR_UINT8   abNameOfStation[1];
    /* TypeOfStation starts directly behind last byte of NameOfStation */
} __PACKED_POST APIOC_DCP_IDENT_ENTRY_IND_DATA_T;

typedef struct
{
  /** packet header */
  TLR_PACKET_HEADER_T                    tHead;
  /** packet data */
  APIOC_DCP_IDENT_ENTRY_IND_DATA_T       tData;
} APIOC_DCP_IDENT_ENTRY_IND_T;

/** DCP IDENT Entry response */
typedef __PACKED_PRE struct
{
  /** reserved */
  TLR_UINT32       ulReserved;
} __PACKED_POST APIOC_DCP_IDENT_ENTRY_RSP_DATA_T;

typedef struct
{
  /** packet header */
  TLR_PACKET_HEADER_T                    tHead;
  /** packet data */
  APIOC_DCP_IDENT_ENTRY_RSP_DATA_T       tData;
} APIOC_DCP_IDENT_ENTRY_RSP_T;

/** packet union */
typedef union
{
  /** indication packet */
  APIOC_DCP_IDENT_ENTRY_IND_T            tInd;
  /** response packet */
  APIOC_DCP_IDENT_ENTRY_RSP_T            tRsp;
} APIOC_DCP_IDENT_ENTRY_PCK_T;


/*
 * DCP IDENTIFY ALL FINISHED SERVICE
 */

/** DCP IDENT FINISHED indication */
typedef __PACKED_PRE struct
{
  /** amount of IDENT responses received (may be greater than the reported responses) */
  TLR_UINT32    ulDevCnt;
} __PACKED_POST  APIOC_DCP_IDENT_FINISHED_IND_DATA_T;

typedef struct
{
  /** packet header */
  TLR_PACKET_HEADER_T                    tHead;
  /** packet data */
  APIOC_DCP_IDENT_FINISHED_IND_DATA_T    tData;
} APIOC_DCP_IDENT_FINISHED_IND_T;

/** DCP IDENT FINISHED response */
typedef __PACKED_PRE struct
{
  /** reserved */
  TLR_UINT32    ulReserved;
} __PACKED_POST  APIOC_DCP_IDENT_FINISHED_RSP_DATA_T;

typedef struct
{
  /** packet header */
  TLR_PACKET_HEADER_T                    tHead;
  /** packet data */
  APIOC_DCP_IDENT_FINISHED_RSP_DATA_T    tData;
} APIOC_DCP_IDENT_FINISHED_RSP_T;

/** packet union */
typedef union
{
  /** indication packet */
  APIOC_DCP_IDENT_FINISHED_IND_T         tInd;
  /** confirmation packet */
  APIOC_DCP_IDENT_FINISHED_RSP_T         tRsp;
} APIOC_DCP_IDENT_FINISHED_PCK_T;


/*
 * DCP RESET FACTORY SETTINGS SERVICE
 */

/** DCP Reset Factory Settings request */
typedef __PACKED_PRE struct
{
  /** MAC address of IO-device to reset */
  TLR_UINT8        tMac[PNIO_LEN_MAC_ADDR];
} __PACKED_POST APIOC_DCP_RESET_FACTORY_REQ_DATA_T;

typedef struct
{
  /** packet header */
  TLR_PACKET_HEADER_T                    tHead;
  /** packet data */
  APIOC_DCP_RESET_FACTORY_REQ_DATA_T     tData;
} APIOC_DCP_RESET_FACTORY_REQ_T;

/** DCP Reset Factory Settings confirmation */
typedef struct
{
  /** packet header */
  TLR_PACKET_HEADER_T                    tHead;
  /** packet data */
  APIOC_DCP_SET_CNF_DATA_T               tData;
} APIOC_DCP_RESET_FACTORY_CNF_T;

/** packet union */
typedef union
{
  /** request packet */
  APIOC_DCP_RESET_FACTORY_REQ_T          tReq;
  /** confirmation packet */
  APIOC_DCP_RESET_FACTORY_CNF_T          tCnf;
} APIOC_DCP_RESET_FACTORY_PCK_T;




/*************************************************************************************/
/*    A L A R M      &     P R O F I N E T - D I A G N O S I S     S E R V I C E     */
/*************************************************************************************/

/*
 * ALARM INDICATION SERVICE
 */

/** Alarm indication */
typedef __PACKED_PRE struct
{
  /** handle to IO-Device */
  TLR_UINT32    ulHandle;
  /** API */
  TLR_UINT32    ulApi;
  /** SlotNumber */
  TLR_UINT16    usSlot;
  /** SubslotNumber */
  TLR_UINT16    usSubslot;
  /** ModuleIdentNumber */
  TLR_UINT32    ulModuleID;
  /** SubmoduleIdentNumber */
  TLR_UINT32    ulSubmoduleID;
  /** AlarmPriority */
  TLR_UINT16    usAlarmPriority;
  /** AlarmType */
  TLR_UINT16    usAlarmType;
  /** Alarm specifier */ /* contains sequence and some flags */
  TLR_UINT16    usAlarmSpecifier;
  /* usAlarmSpecifier is defined as follows
  bit 0 - 10    usAlarmSequence
  bit 11        fDiagChannelAvailable
  bit 12        fDiagGenericAvailable
  bit 13        fDiagSubmodAvailable
  bit 14        fReserved
  bit 15        fArDiagnosisState */

  /** UserStructureIdentifier */
  TLR_UINT16    usUserStructIdent;
  /** alarm data */ /* this field contains only the first byte, all other follow directly behind */
  TLR_UINT8     abAlarmData[1];
} __PACKED_POST APIOC_ALARM_IND_DATA_T;

typedef struct
{
  /** packet header */
  TLR_PACKET_HEADER_T                    tHead;
  /** packet data */
  APIOC_ALARM_IND_DATA_T                 tData;
} APIOC_ALARM_IND_T;

/** Alarm response */
typedef __PACKED_PRE struct
{
  /** handle to IO-Device */
  TLR_UINT32    ulHandle;
  /** Alarm specifier */ /* contains sequence and some flags */
  TLR_UINT16    usAlarmSpecifier;
  /** reserved */
  TLR_UINT16    usReserved;
} __PACKED_POST APIOC_ALARM_RSP_DATA_T;

typedef struct
{
  /** packet header */
  TLR_PACKET_HEADER_T                    tHead;
  /** packet data */
  APIOC_ALARM_RSP_DATA_T                 tData;
} APIOC_ALARM_RSP_T;

/** packet union */
typedef union
{
  /** indication packet */
  APIOC_ALARM_IND_T                      tInd;
  /** response packet */
  APIOC_ALARM_RSP_T                      tRsp;
} APIOC_ALARM_PCK_T;

/*
 * ALARM ACKNOWLEDGE SERVICE
 */

/** Alarm Acknowledge request */
typedef __PACKED_PRE struct
{
  /** handle to IO-Device */
  TLR_UINT32    ulHandle;
  /** alarm specifier */
  TLR_UINT16    usAlarmSpecifier;
  /** reserved */
  TLR_UINT16    usReserved;
}  __PACKED_POST APIOC_ALARM_ACK_REQ_DATA_T;

typedef struct
{
  /** packet header */
  TLR_PACKET_HEADER_T                    tHead;
  /** packet data */
  APIOC_ALARM_ACK_REQ_DATA_T             tData;
} APIOC_ALARM_ACK_REQ_T;

/** Alarm ACKnowledge confirmation */
typedef __PACKED_PRE struct
{
  /** handle to IO-Device */
  TLR_UINT32  ulHandle;
  /** alarm specifier */
  TLR_UINT16    usAlarmSpecifier;
  /** reserved */
  TLR_UINT16    usReserved;
  /** PNIO status */
  TLR_UINT32  ulStatus;
}  __PACKED_POST APIOC_ALARM_ACK_CNF_DATA_T;

typedef struct
{
  /** packet header */
  TLR_PACKET_HEADER_T                    tHead;
  /** packet data */
  APIOC_ALARM_ACK_CNF_DATA_T             tData;
} APIOC_ALARM_ACK_CNF_T;

/** packet union */
typedef union
{
  /** request packet */
  APIOC_ALARM_ACK_REQ_T                  tReq;
  /** confirmation packet */
  APIOC_ALARM_ACK_CNF_T                  tCnf;
}  APIOC_ALARM_ACK_PCK_T;


/*
 * PROFINET DIAGNOSIS SERVICE
 */

/** Diagnosis data indication */
typedef APIOC_ALARM_IND_T APIOC_DIAG_DATA_IND_T;

/** Diagnosis data response */
typedef __PACKED_PRE struct
{
  /** device handle */
  TLR_UINT32 ulHandle;
} __PACKED_POST APIOC_DIAG_DATA_RSP_DATA_T;

typedef struct
{
  /** packet header */
  TLR_PACKET_HEADER_T                    tHead;
  /** packet data */
  APIOC_DIAG_DATA_RSP_DATA_T             tData;
} APIOC_DIAG_DATA_RSP_T;

/** packet union */
typedef union
{
  /** indication packet */
  APIOC_DIAG_DATA_IND_T                  tInd;
  /** response packet */
  APIOC_DIAG_DATA_RSP_T                  tRsp;
}  APIOC_DIAG_DATA_PCK_T;


/*
 * GET IO-DEVICE DIAGNOSIS SERVICE
 */

#define PNIO_IOD_DIAG_IOC_DELETE_BUFFER       0x001 /* delete IOC's diagnosis buffer after reading */

/* Get Device Diagnosis Request */
typedef __PACKED_PRE struct
{
  /** handle to IO-device */
  TLR_UINT32                     ulHandle;
  /** Flags */
  TLR_UINT32                     ulFlags;
}  __PACKED_POST APIOC_DEVICE_DIAG_REQ_DATA_T;

typedef struct
{
  /** packet header */
  TLR_PACKET_HEADER_T                    tHead;
  /* packet data */
  APIOC_DEVICE_DIAG_REQ_DATA_T           tData;
} APIOC_DEVICE_DIAG_REQ_T;

#define PNIO_IOD_DIAG_IOD_NON_EXIST           0x001  /* IO-Device is not responsing to DCP Ident */
#define PNIO_IOD_DIAG_IOD_NOT_READY           0x002  /* IO-Device is not in cyclic data exchange */
#define PNIO_IOD_DIAG_IOD_CFG_FAULT           0x004  /* IP or NameOfStation exists more than once */
#define PNIO_IOD_DIAG_IOD_INVALID_RESPONSE    0x008  /* IO-Device sent an invalid DCP response */
#define PNIO_IOD_DIAG_IOD_PRM_FAULT           0x010  /* IO-Device sent an RPC response with error */
#define PNIO_IOD_DIAG_IOD_DEACTIVATED         0x020  /* IO-Device was deactivated by user */

#define PNIO_IOD_DIAG_IOD_DIAGNOSIS_PRESENT   0x040  /* IO-device diagnosis-alarm was received and is stored in IO-Controller's buffer */
#define PNIO_IOD_DIAG_IOD_DIAG_DISAPPEARED    0x080  /* IO-device send a "diagnosis-disappears"-alarm */
#define PNIO_IOD_DIAG_IOC_BUFFER_OVERFLOW     0x100  /* IOC's diagnosis buffer was to small for last incoming diagnosis data */
#define PNIO_IOD_DIAG_IOC_BUFFER_OVERWRITTEN  0x200  /* IOC's diagnosis buffer was overwritten before Application read it */

#define PNIO_IOD_DIAG_PCK_DIAG_LEN_TOO_SMALL  0x400  /* applications packet is to small for all the diagnosis in IOC's diagnosis buffer */
#define PNIO_IOD_DIAG_MODULE_DIFF_REPORTED    0x800  /* IO-Device reported a ModuleDiffBlock in Connect-Response */
#define PNIO_IOD_DIAG_CONNECT_HELLO_TRIGGERED 0x1000 /* if set the current Connection was established because a Hello was received */

/* Get Device Diagnosis Confirmation */
typedef __PACKED_PRE struct
{
  /** handle to IO-Device */
  TLR_UINT32                     ulHandle;
  /** status flag */
  TLR_UINT32                     ulFlags;
  /** length of diagnosis data */
  TLR_UINT32                     ulDiagLength;
  /** first byte of diagnosis data */
  TLR_UINT8                      abDiagData[1];
} __PACKED_POST APIOC_DEVICE_DIAG_CNF_DATA_T;

typedef struct
{
  /** packet header */
  TLR_PACKET_HEADER_T                    tHead;
  /* packet data */
  APIOC_DEVICE_DIAG_CNF_DATA_T           tData;
} APIOC_DEVICE_DIAG_CNF_T;

/* Packet union */
typedef union
{
  /** request packet */
  APIOC_DEVICE_DIAG_REQ_T                tReq;
  /** confirmation packet */
  APIOC_DEVICE_DIAG_CNF_T                tCnf;
} APIOC_DEVICE_DIAG_PCK_T;




/*************************************************************************************/
/*                         V A R I O U S     S E R V I C E S                         */
/*************************************************************************************/

/*
 * GET MODULEDIFFBLOCK SERVICE
 */

/** Get ModuleDiffBlock of IO-Device request */
typedef __PACKED_PRE struct
{
  /** device handle */
  TLR_UINT32    ulHandle;
  /** max response length */
  TLR_UINT32    ulMaxRspLength;
} __PACKED_POST APIOC_GET_MOD_DIFF_BLOCK_REQ_DATA_T;

typedef struct
{
  /** packet header */
  TLR_PACKET_HEADER_T                    tHead;
  /** packet data */
  APIOC_GET_MOD_DIFF_BLOCK_REQ_DATA_T    tData;
} APIOC_GET_MOD_DIFF_BLOCK_REQ_T;

/** Get ModuleDiffBlock of IO-Device confirmation */
typedef __PACKED_PRE struct
{
  /** device handle */
  TLR_UINT32    ulHandle;
  /** flag to signal that the ModuleDiffBlock is bigger than this confirmation */
  TLR_UINT32    ulFlag;
  /** number of APIs inside ModuleDiffBlock */
  TLR_UINT16    usNumAPI;
  /** first byte of ModuleDiffBlock */
  TLR_UINT8     abModDiffBlock[1];
} __PACKED_POST APIOC_GET_MOD_DIFF_BLOCK_CNF_DATA_T;

typedef struct
{
  /** packet header */
  TLR_PACKET_HEADER_T                    tHead;
  /** packet data */
  APIOC_GET_MOD_DIFF_BLOCK_CNF_DATA_T    tData;
} APIOC_GET_MOD_DIFF_BLOCK_CNF_T;

/** packet union */
typedef union
{
  /** request packet */
  APIOC_GET_MOD_DIFF_BLOCK_REQ_T         tReq;
  /* confirmation packet */
  APIOC_GET_MOD_DIFF_BLOCK_CNF_T         tCnf;
} APIOC_GET_MOD_DIFF_BLOCK_PCK_T;


/*
 * GET STACK DIAGNOSIS SERVICE
 */

/** Get Stack Diagnosis request */
typedef TLR_EMPTY_PACKET_T APIOC_GET_STACK_DIAG_REQ_T;

/** Get Stack Diagnosis confirmation */
typedef __PACKED_PRE struct
{
  TLR_UINT32    ulCommunicationError;
  TLR_UINT32    ulApctlErrorCode;
  TLR_UINT32    ulApctlFlags;
  TLR_UINT32    ulApcfgErrorCode;
  TLR_UINT32    ulApcfgIodCnt;
  TLR_UINT32    ulApcfgIocrCnt;
  TLR_UINT32    ulApcfgAPICnt;
  TLR_UINT32    ulApcfgModuleCnt;
  TLR_UINT32    ulApcfgSubmodCnt;
  TLR_UINT32    ulApcfgSubmodDescrCnt;
  TLR_UINT32    ulApcfgRecordCnt;
  TLR_UINT32    ulApcfgActIodCnt;
} __PACKED_POST APIOC_GET_STACK_DIAG_CNF_DATA_T;

typedef struct
{
  /** packet header */
  TLR_PACKET_HEADER_T                    tHead;
  /** packet data */
  APIOC_GET_STACK_DIAG_CNF_DATA_T        tData;
} APIOC_GET_STACK_DIAG_CNF_T;

/** packet union */
typedef union
{
  /** request packet */
  APIOC_GET_STACK_DIAG_REQ_T             tReq;
  /* confirmation packet */
  APIOC_GET_STACK_DIAG_CNF_T             tCnf;
} APIOC_GET_STACK_DIAG_PCK_T;


/*
 * GET CMCTL CONNECTRESULTS SERVICE
 */
/** Get CMCTL ConnectResults request */
typedef TLR_EMPTY_PACKET_T APIOC_GET_CMCTL_CONNECT_RES_REQ_T;

/** Get CMCTL ConnectResults confirmation */
typedef __PACKED_PRE struct
{
  /** device handle */
  TLR_UINT32    ulHandle;
  /** amount of connect tries - value no longer usable since firmware v2.5.x */
  /* the following value is no longer containing a valid value.
   * however for compatibility reasons it stays in the packet definition
   * and is set to 0xFFFFFFFF. */
  TLR_UINT32    ulConnectTries;
  /** last connect result */
  TLR_UINT32    ulLastConnectResult;
} __PACKED_POST APIOC_GET_CMCTL_CONNECT_RES_CNF_DATA_T;

typedef struct
{
  /** packet header */
  TLR_PACKET_HEADER_T                    tHead;
  /** packet data - array of struct, depending on amount of configured IO-Devices */
  APIOC_GET_CMCTL_CONNECT_RES_CNF_DATA_T atData[1];
} APIOC_GET_CMCTL_CONNECT_RES_CNF_T;

/** packet union */
typedef union
{
  /** request packet */
  APIOC_GET_CMCTL_CONNECT_RES_REQ_T             tReq;
  /* confirmation packet */
  APIOC_GET_CMCTL_CONNECT_RES_CNF_T             tCnf;
} APIOC_GET_CMCTL_CONNECT_RES_PCK_T;


/*
 * GET CONNECTION INFO SERVICE
 * This service is described in DPM Manual
 *    only the stack related confirmation is described here
 */

#define APIOC_ACTIVE_DEVICE_CONNECT_INFO_STRUCT_ID        0x2245

typedef __PACKED_PRE struct
{
  /** length of NameOfStation */
  TLR_UINT32                        ulLenName;
  /** length of TypeOfStation */
  TLR_UINT32                        ulLenType;
  /** IP address */
  TLR_UINT32                        ulIPAddress;
  /** Flags to code diagnosis information */
  TLR_UINT32                        ulDiagFlags;
  /** device ID */
  TLR_UINT16                        usDeviceID;
  /** vendor ID */
  TLR_UINT16                        usVendorID;
  /** MAC address */
  TLR_UINT8                         abMac[PNIO_LEN_MAC_ADDR];
  /** reserved */
  TLR_UINT16                        usReserved;
  /** NameOfStation */
  TLR_UINT8                         abName[PNIO_MAX_NAME_OF_STATION];
  /** TypeOfStation */
  TLR_UINT8                         abType[PNIO_MAX_TYPE_OF_STATION];
} __PACKED_POST  APIOC_ACTIVE_DEVICE_CONNECT_INFO_T;


#define APIOC_INACTIVE_DEVICE_CONNECT_INFO_STRUCT_ID      0x2244

typedef __PACKED_PRE struct
{
  /** length of device name */
  TLR_UINT32                        ulLenName;
  /** Flags to code diagnosis information */
  TLR_UINT32                        ulDiagFlags;
  /** device ID */
  TLR_UINT16                        usDeviceID;
  /** vendor ID */
  TLR_UINT16                        usVendorID;
  /** NameOfStation */
  TLR_UINT8                         abName[PNIO_MAX_NAME_OF_STATION];
} __PACKED_POST APIOC_INACTIVE_DEVICE_CONNECT_INFO_T;




/*************************************************************************************/
/*                    D E P R E C A T E D     S E R V I C E S                       */
/*************************************************************************************/

#define  PNIO_APCTL_CMD_APPL_REGISTER_REQ           0x00000C28
#define  PNIO_APCTL_CMD_APPL_REGISTER_CNF           0x00000C29

#define  PNIO_APCTL_CMD_APPL_DEREGISTER_REQ         0x00000C2A
#define  PNIO_APCTL_CMD_APPL_DEREGISTER_CNF         0x00000C2B


/*
 * APPLICATION DEREGISTER SERVICE - no longer supported
 * use service described in DPM Manual instead
 */

/* FORCE DeRegistering currently registered application */
#define PNIO_APCTL_FORCE_APPL_DEREGISTER       0x001

/** Application Deregister Request */
typedef __PACKED_PRE struct
{
  /** Flags */
  TLR_UINT32    ulFlags;
}  __PACKED_POST APIOC_APPLICATION_DEREGISTER_REQ_DATA_T;

typedef struct
{
  /** packet header */
  TLR_PACKET_HEADER_T                     tHead;
  /** packet data */
  APIOC_APPLICATION_DEREGISTER_REQ_DATA_T tData;
} APIOC_APPLICATION_DEREGISTER_REQ_T;

/** Application Deregister Confirmation */
typedef __PACKED_PRE struct
{
  /** reserved */
  TLR_UINT32    ulReserved;
} __PACKED_POST APIOC_APPLICATION_DEREGISTER_CNF_DATA_T;

typedef struct
{
  /** packet header */
  TLR_PACKET_HEADER_T                     tHead;
  /** packet data */
  APIOC_APPLICATION_DEREGISTER_CNF_DATA_T tData;
} APIOC_APPLICATION_DEREGISTER_CNF_T;

/** packet union */
typedef union
{
  /** request packet */
  APIOC_APPLICATION_DEREGISTER_REQ_T      tReq;
  /** confirmation packet */
  APIOC_APPLICATION_DEREGISTER_CNF_T      tCnf;
} APIOC_APPLICATION_DEREGISTER_PCK_T;


/*
 * APPLICATION REGISTER SERVICE - no longer supported
 * use service described in DPM Manual instead
 */

/** Application register Request */
typedef TLR_EMPTY_PACKET_T APIOC_APPLICATION_REGISTER_REQ_T;

/** Application register confirmation */
typedef TLR_EMPTY_PACKET_T APIOC_APPLICATION_REGISTER_CNF_T;

/** packet union */
typedef union
{
  /** request packet */
  APIOC_APPLICATION_REGISTER_REQ_T        tReq;
  /** confirmation packet */
  APIOC_APPLICATION_REGISTER_CNF_T        tCnf;
} APIOC_APPLICATION_REGISTER_PCK_T;


/*
 * START/STOP COMMUNICATION SERVICE - no longer supported
 * use service described in DPM Manual instead
 */

#define APIOC_START_COMM  1
#define APIOC_STOP_COMM   2

/**  Start/Stop Communication Request */
typedef __PACKED_PRE struct
{
  TLR_UINT32 ulParam;
} __PACKED_POST APIOC_START_STOP_COMM_REQ_DATA_T;

typedef struct
{
  /** packet header */
  TLR_PACKET_HEADER_T                     tHead;
  /** packet data */
  APIOC_START_STOP_COMM_REQ_DATA_T        tData;
} APIOC_START_STOP_COMM_REQ_T;


/* Start/Stop Communication Confirmation */
typedef TLR_EMPTY_PACKET_T APIOC_START_STOP_COMM_CNF_T;

/** packet union */
typedef union
{
  /* request packet */
  APIOC_START_STOP_COMM_REQ_T             tReq;
  /* confirmation packet */
  APIOC_START_STOP_COMM_CNF_T             tCnf;
} APIOC_START_STOP_COMM_PCK_T;


/* pragma unpack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_UNPACK_1(__PNIO_APCTL_PACKET)
#endif

/*************************************************************************************/
#endif /* #ifndef __PNIO_APCTL_PUBLIC_H */
